/*
 * Decompiled with CFR 0.152.
 */
package filenet.pe.peorb.client;

import filenet.vw.api.VWException;
import filenet.vw.base.JVMSystemConstants;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.apache.http.ConnectionReuseStrategy;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.HttpRequestRetryHandler;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.conn.params.ConnManagerParams;
import org.apache.http.conn.params.ConnPerRoute;
import org.apache.http.conn.params.ConnPerRouteBean;
import org.apache.http.conn.scheme.PlainSocketFactory;
import org.apache.http.conn.scheme.Scheme;
import org.apache.http.conn.scheme.SchemeRegistry;
import org.apache.http.conn.scheme.SocketFactory;
import org.apache.http.conn.ssl.SSLSocketFactory;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.impl.client.DefaultHttpRequestRetryHandler;
import org.apache.http.impl.conn.tsccm.ThreadSafeClientConnManager;
import org.apache.http.params.BasicHttpParams;
import org.apache.http.params.HttpParams;
import org.apache.http.protocol.HttpContext;

public class HttpClientWrapper {
    private static boolean useTcpNoDelay = true;
    private static boolean staleConnectionCheck = false;
    private static int socketTimeout = 0;
    private static int socketBufferSize = 8192;
    private static int maxTotalConnections = 300;
    private static int maxConnectionsPerRoute = 100;
    private static Exception FAILED_HTTPCLIENT_INIT;
    private static HttpParams GHTTPPARAMS;
    private static TrustManager fntrustAll;
    private static SchemeRegistry GSCHEMEREGISTRY;
    private static boolean GINIT_OK;
    private DefaultHttpClient GHTTPCLIENT = null;
    public String GHTTPCLIENT_STATUS = null;

    private static void EstablishHTTPClientContext() throws Exception {
        fntrustAll = new X509TrustManager(){

            public void checkClientTrusted(X509Certificate[] arg0, String arg1) throws CertificateException {
            }

            public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
            }

            public X509Certificate[] getAcceptedIssuers() {
                return null;
            }
        };
        SSLContext sslcontext = SSLContext.getInstance("TLS");
        sslcontext.init(null, new TrustManager[]{fntrustAll}, null);
        SSLSocketFactory sf = new SSLSocketFactory(sslcontext);
        sf.setHostnameVerifier(SSLSocketFactory.ALLOW_ALL_HOSTNAME_VERIFIER);
        GHTTPPARAMS = new BasicHttpParams();
        GHTTPPARAMS.setBooleanParameter("http.connection.stalecheck", staleConnectionCheck);
        GHTTPPARAMS.setBooleanParameter("http.tcp.nodelay", useTcpNoDelay);
        GHTTPPARAMS.setIntParameter("http.socket.timeout", socketTimeout);
        GHTTPPARAMS.setIntParameter("http.socket.buffer-size", socketBufferSize);
        ConnManagerParams.setMaxTotalConnections((HttpParams)GHTTPPARAMS, (int)maxTotalConnections);
        ConnManagerParams.setMaxConnectionsPerRoute((HttpParams)GHTTPPARAMS, (ConnPerRoute)new ConnPerRouteBean(maxConnectionsPerRoute));
        GSCHEMEREGISTRY = new SchemeRegistry();
        GSCHEMEREGISTRY.register(new Scheme("http", (SocketFactory)PlainSocketFactory.getSocketFactory(), 80));
        GSCHEMEREGISTRY.register(new Scheme("https", (SocketFactory)sf, 443));
    }

    public void cleanup() {
        if (this.GHTTPCLIENT != null && this.GHTTPCLIENT.getConnectionManager() != null) {
            this.GHTTPCLIENT.getConnectionManager().shutdown();
        }
    }

    protected HttpClientWrapper() throws Throwable {
        try {
            if (!GINIT_OK) {
                throw FAILED_HTTPCLIENT_INIT;
            }
            ThreadSafeClientConnManager cm = new ThreadSafeClientConnManager(GHTTPPARAMS, GSCHEMEREGISTRY);
            this.GHTTPCLIENT = new DefaultHttpClient((ClientConnectionManager)cm, GHTTPPARAMS);
            this.GHTTPCLIENT.setReuseStrategy(new ConnectionReuseStrategy(){

                public boolean keepAlive(HttpResponse response, HttpContext context) {
                    return true;
                }
            });
            this.GHTTPCLIENT.setHttpRequestRetryHandler((HttpRequestRetryHandler)new DefaultHttpRequestRetryHandler());
            this.GHTTPCLIENT_STATUS = "OK";
        }
        catch (Throwable e) {
            e.printStackTrace();
            this.GHTTPCLIENT_STATUS = "EXCEPTION:" + VWException.DescribeThrowableCompletely(e);
            throw e;
        }
    }

    protected HttpClient getHttpClient() {
        return this.GHTTPCLIENT;
    }

    static {
        staleConnectionCheck = Boolean.parseBoolean(JVMSystemConstants.GetPrivilegedSystemPropertyWithDefault("http.connection.stalecheck", "false"));
        useTcpNoDelay = Boolean.parseBoolean(JVMSystemConstants.GetPrivilegedSystemPropertyWithDefault("http.tcp.nodelay", "true"));
        socketTimeout = (int)JVMSystemConstants.GetLongPrivilegedSystemPropertyWithDefault("http.socket.timeout", 0L);
        socketBufferSize = (int)JVMSystemConstants.GetLongPrivilegedSystemPropertyWithDefault("http.socket.buffer-size", 0L);
        maxTotalConnections = (int)JVMSystemConstants.GetLongPrivilegedSystemPropertyWithDefault("http.conn-manager.max-total", 300L);
        maxConnectionsPerRoute = (int)JVMSystemConstants.GetLongPrivilegedSystemPropertyWithDefault("http.conn-manager.max-per-route", 100L);
        FAILED_HTTPCLIENT_INIT = new Exception("Failed to initialized HTTP Client");
        GHTTPPARAMS = null;
        fntrustAll = null;
        GSCHEMEREGISTRY = null;
        GINIT_OK = true;
        try {
            HttpClientWrapper.EstablishHTTPClientContext();
        }
        catch (Throwable e) {
            FAILED_HTTPCLIENT_INIT.initCause(e);
            GINIT_OK = false;
        }
    }

    static class FnHostnameVerifier
    implements HostnameVerifier {
        FnHostnameVerifier() {
        }

        public boolean verify(String arg0, SSLSession arg1) {
            return true;
        }
    }
}

